import { StateNode } from "./StateNode.mjs";
class RootState extends StateNode {
  static id = "root";
  static initial = "";
  static children = () => [];
  onKeyDown = (info) => {
    switch (info.code) {
      case "KeyZ": {
        if (!(info.shiftKey || info.ctrlKey)) {
          const currentTool = this.getCurrent();
          if (currentTool && currentTool.getCurrent()?.id === "idle" && this.children["zoom"]) {
            this.editor.setCurrentTool("zoom", { ...info, onInteractionEnd: currentTool.id });
          }
        }
        break;
      }
    }
  };
}
export {
  RootState
};
//# sourceMappingURL=RootState.mjs.map
